#include "hal_base.h"
#include "hal_flash.h"
#include "hal_irq.h"

hal_status_t status;	// պ״̬
uint8_t loop;			// ִдͳ

/* FLASH̲дFRAHFRAHNʹж */
void iap_test(void)
{
	FLASH_UNLOCK();
	FRAL   = 0x00;
	FRALN  = ~(0x00 & 0xff);
	FRAH   = 0x1e;
	FRAHN  = 0x1e;
	ROMDL  = 0x55;
	ROMDLN = ~0x55;
	ROMDH  = 0x55;
	ROMDHN = ~0x55;
	FLASH_PROGRAMME();
	FLASH_LOCK();
}

/* жϷʹжϣINVT = 00IAPIG0УжڵַΪ0x0008 */
void isr_iap_handler(void) interrupt_high 0x0008
{
	if (irq_get_it_status(IAPIE_IT) && irq_get_flag_status(IAPIE_IT)) {
		irq_clear_flag_status(IAPIE_IT);
		loop++;
	}
}



void main() 
{
	// RAMʼ
	ram_clear();
	// ι
	CLRWDT();
	// clockʼѡHRC,Ƶʹclock 
	status = clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);

	//ѡж
	INTVEN0 = 1;
	// ʹܵȼж
	GIEL = 1;
	// ʹж
	IRQ_GIE_CFG(1);
	// ʹIAPж
	irq_config(IAPIE_IT, ENABLE);

	// ִIAP
	iap_test();

	while (1) {
		// ι
		CLRWDT();
	}
}